/*------------------------------------------------------------------------------*
 * File Name: FOFunctPrev.h														*
 * Purpose: OriginC Source file													*
 * Copyright (c) OriginLab Corp. 2009											*
 * All Rights Reserved															*
 *																				*
 * Modification Log:															*
 * Kenny 18/03/09 QA80-13291-P1 FIX_INVALID_FUNC_SOURCE_CAUSE_FAIL_LOAD_PREVIEW	*	
 * Jasmine 04/16/09 QA80-13424 REWRITE_FUNCTION_TO_GET_PREVIEW_NAME				*
 *------------------------------------------------------------------------------*/

//#include <msgmap.h>
#ifndef _NFPREVIEW_H
#define _NFPREVIEW_H

class NFPreviewControl : public ResizeControl
{
public:
	NFPreviewControl() : ResizeControl()
	{
		m_bViewFunctionFirstTime = true;//CPY 5/26/04 v7.5878 FO_FUNC_PREVIEW_IMPROVEMENT
	}
	void Init(int nCntrlID, WndContainer& wndParent,int nIndex = 0, LPCSTR lpcszDlgName = NULL)
	{
		InitControl(nCntrlID, wndParent );
	   	Control ctrl = wndParent.GetDlgItem(nCntrlID);
    	m_pcFunctPrev.CreateControl(ctrl.GetSafeHwnd());
    	SetVisible(false);
 		m_strFuncName = "";
	   	//m_pcFunctPrev.Visible = false;

 	}
 	
public:
	///Frank 8/19/04 CLEAN_UP_FUNCTION_PREVIEW_CODE
	bool	LoadNLSFFunctionPreview(TreeNode &trFunction, bool	bFormular)
	{
		if(!trFunction)
			return false;

		//---- CPY 5/26/04 v7.5878 FO_FUNC_PREVIEW_IMPROVEMENT
		if(m_bViewFunctionFirstTime)
		{
			m_bViewFunctionFirstTime = false;
			///-----Frank 11/25/05 MOVE_FDFTREE_RELATE_TO_ANALYSIS_ULTIS
			/*
			string strPath = GetAppPath(TRUE);	  // need to use system (installed) path
			nlsf_init_math_equ_fonts(strPath);
			*/
			nlf_init_math_equ_fonts();
			///-----End MOVE_FDFTREE_RELATE_TO_ANALYSIS_ULTIS
		}
		//----	

		string strFunctionName;//, strFDFname;	///Jasmine 04/16/09 QA80-13424 REWRITE_FUNCTION_TO_GET_PREVIEW_NAME, strFDFname is not used so I comment it
		string strFilePath;
		bool	bUpdateCurve; 
		///Jasmine 04/16/09 QA80-13424 REWRITE_FUNCTION_TO_GET_PREVIEW_NAME
		//if(nlf_get_func_names(trFunction, strFunctionName, strFDFname,&strFilePath))
		if( nlf_get_func_preview_names(trFunction, strFunctionName, strFilePath) )
		///End REWRITE_FUNCTION_TO_GET_PREVIEW_NAME
		{
			///Frank v8.0174	12/15/04			SEPARATE_GUI_AND_ACTION		
			TreeNode	trCurvePict =  trFunction.Curve;
			if(trCurvePict && !bFormular)
				bUpdateCurve = true;
			///End			SEPARATE_GUI_AND_ACTION		
			//if(0 != lstrcmpi(strFunctionName, m_strFuncName))
			///Kenny 18/03/09 QA80-13291-P1 FIX_INVALID_FUNC_SOURCE_CAUSE_FAIL_LOAD_PREVIEW
			//if(0 != lstrcmpi(strFunctionName, m_strFuncName)||bUpdateCurve)
			if( isFunctionChanged(strFunctionName) || bUpdateCurve )
			///End FIX_INVALID_FUNC_SOURCE_CAUSE_FAIL_LOAD_PREVIEW
			{
				///Jasmine 04/16/09 QA80-13424 REWRITE_FUNCTION_TO_GET_PREVIEW_NAME
				//if(strFDFname.IsEmpty())
					//strFDFname = GetFileName(strFilePath,true);
				///End REWRITE_FUNCTION_TO_GET_PREVIEW_NAME
				///Frank v8.0174	12/15/04			SEPARATE_GUI_AND_ACTION		
				if(trCurvePict && bUpdateCurve)
					if(SetPicture(trCurvePict, true))
					{
						m_strFuncName = strFunctionName ;
						return true;
					}
				///End			SEPARATE_GUI_AND_ACTION		
				if(LoadPreview(bFormular, strFilePath, strFunctionName))	///Jasmine 06/11/07 LOAD_SAMPLE_EQUATION_AND_CURVE_OF_USER_DEFINE_FUNC
					m_strFuncName = strFunctionName ; //storage the function 
				else
				{
					m_strFuncName = "";
					return false;
				}
				//LoadPreview(bFormular, strFDFname, strFunctionName);
				//m_strFuncName = strFunctionName ; //storage the function 
			}
			else 
				//if(0 == lstrcmpi(m_strFuncName,"") )
				if(m_strFuncName.IsEmpty() )
					return false;
	
			return true;			
		}
		
		return false;
	}
	///End CLEAN_UP_FUNCTION_PREVIEW_CODE
	
	//Frank 7/06/04 v8.0901 QA70-6483 LOAD_CURVE_FROM_FDF
	bool SetPicture(TreeNode &trPictHold, bool bKeepAspectRatio = true)
	{
		PictureHolder pictHold;//(trPictHold.pict);///Jasmine 03/08/06 avoid runtime error  
		pictHold = trPictHold.pict;
		if(m_pcFunctPrev.SetPicture(pictHold))
		{
			m_pcFunctPrev.KeepAspectRatio = bKeepAspectRatio;
			return true;
		}	
		return false;
	}
	//End LOAD_CURVE_FROM_FDF
	
	//---- CPY 5/26/04 v7.5878 FO_FUNC_PREVIEW_IMPROVEMENT
	// bFormular = false will load Curve Preview
	bool LoadPreview(bool bFormular, const string& strFDFName, const string &strFuncName, bool bKeepAspectRatio = true)
	{
		Tree		trPict;
		trPict.Pict.ID = 1;
		///Jasmine 06/11/07 LOAD_SAMPLE_EQUATION_AND_CURVE_OF_USER_DEFINE_FUNC
		if(!nlf_get_preview_image(trPict.Pict, GetFileName(strFDFName,true), strFuncName, bFormular))
			//return false;
			//return LoadBarePreView(trPict.Pict, bFormular);	///Jasmine 03/01/07 SAMPLE_EQUATION_AND_CURVE_FOR_USER_DEFINE_FUNC
			LoadUserDefinedPreview(trPict.Pict, strFDFName, bFormular);
		///End LOAD_SAMPLE_EQUATION_AND_CURVE_OF_USER_DEFINE_FUNC
		return SetPicture(trPict.Pict, bKeepAspectRatio);
	}
	//----
	bool LoadBitMap(LPCSTR lpcstrBitMapPath , bool bKeepAspectRatio = true)
	{
		Tree trPict;
		trPict.Pict.ID = 1;
		PictureHolder pictHold;//(trPictHold.pict);
		if(pictHold.Load(lpcstrBitMapPath))
			trPict.Pict.pict =  pictHold;
		
		if(!trPict.IsValid())
			return false;
		return SetPicture(trPict.Pict, bKeepAspectRatio);
	}
	bool SetVisible( bool bSetVisible  = true)
	{
		m_pcFunctPrev.Visible = bSetVisible;
		return true;
	}
	///Jasmine 06/11/07 LOAD_SAMPLE_EQUATION_AND_CURVE_OF_USER_DEFINE_FUNC
	bool LoadUserDefinedPreview(TreeNode trPict, LPCSTR lpcstrFDFName, bool bFormular)
	{
		string strMeta = GetFilePath(lpcstrFDFName) + GetFileName(lpcstrFDFName, true);
		if(bFormular)
			strMeta += ".wmf";
		else
			strMeta += ".cuv";
		if(strMeta.IsFile())
		{
			HMETAFILE hmf = NULL;
			RECT16 rect;
			hmf = load_metafile(strMeta, &rect);
			PictureHolder pictHold;
			if(hmf && pictHold.CreateFromMetafile( hmf, rect.right - rect.left, rect.bottom - rect.top , true))
			{
				trPict.pict =  pictHold;
				return true;
			}
		}
		return false;
	}
	///End LOAD_SAMPLE_EQUATION_AND_CURVE_OF_USER_DEFINE_FUNC
	///Jasmine 03/01/07 SAMPLE_EQUATION_AND_CURVE_FOR_USER_DEFINE_FUNC
	bool LoadBarePreView(TreeNode& trPict, bool bFormular)
	{	
		/*
		PictureHolder pictHold;
		Tree	trPict;
		trPict.Pict = "";
		//pichHold
		bool bRet = 	m_pcFunctPrev.SetPicture(pictHold);
		if(!bRet)
			SetVisible(false);
		return false;
		*/
		nlf_get_preview_image(trPict, _L("userdefine"), _L("userdefine"), bFormular);
		return SetPicture(trPict);
	}	
	///End SAMPLE_EQUATION_AND_CURVE_FOR_USER_DEFINE_FUNC
	///Kenny 18/03/09 QA80-13291-P1 FIX_INVALID_FUNC_SOURCE_CAUSE_FAIL_LOAD_PREVIEW
private:
	BOOL isFunctionChanged(const string& strCurrentFunctionName)
	{
		return ( m_strFuncName.IsEmpty() || 0 != lstrcmpi(strCurrentFunctionName, m_strFuncName) );
	}
	///End FIX_INVALID_FUNC_SOURCE_CAUSE_FAIL_LOAD_PREVIEW
private:
	bool				m_bViewFunctionFirstTime;//-------- CPY 6/5/05 MOVE_NLFORMULA_FONT_INIT_TO_ONE_PLACE
	
protected:
	PictureControl		m_pcFunctPrev;
	string 				m_strFuncName;
};
#endif //_NFPREVIEW_H
